// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from engine (per vertex / mesh)
attribute vec2 in_dir;
attribute vec2 in_transparency_and_distance_idx;

// Input from engine (per instance)
attribute vec2 in_instance_pos;
attribute vec4 in_instance_seg_dists;
attribute vec4 in_instance_color;

// Output to pixel shader
varying lowp vec4 pixel_color;

void main(void)
{
	float distance = in_instance_seg_dists[int(in_transparency_and_distance_idx.y)];
	vec2 pos = in_instance_pos + in_dir * distance;

	gl_Position = to_screen_pos_2d(pos);
	pixel_color = in_instance_color * in_transparency_and_distance_idx.x;
}
