// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from vertex shader
varying lowp vec4 pixel_color;
varying mediump vec2 pixel_uv;

uniform sampler2D uni_texture_diffuse;

void main(void) 
{
	lowp vec4 texture_color = texture2D(uni_texture_diffuse, pixel_uv);
	
	gl_FragColor.rgb = texture_color.rgb * pixel_color.rgb * LIGHTMAP_COLOR_WRITE_FACTOR;
	gl_FragColor.a = texture_color.a * pixel_color.a;
}
