// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from engine (per vertex)
attribute vec2 in_pos;
attribute vec2 in_uv;
attribute vec2 in_angle_and_depth; 

// Input from engine (per instance)
attribute vec2 in_instance_pos;
attribute float in_instance_shadow_map_v;
attribute float in_instance_scale;
attribute float in_instance_rotation;
attribute vec4 in_instance_sprite_uv_rect;
attribute vec3 in_instance_color;

// Output to pixel shader
varying vec2 frag_light_texture_uv;
varying vec2 frag_mesh_pos;
varying vec2 frag_shadow_map_uv;
varying float frag_depth;
varying vec3 frag_color;

void main(void)
{
 	// Note: in_pos is 0 centered, so simple rotation and scale works

	// Rotate
	float s = sin(in_instance_rotation);
	float c = cos(in_instance_rotation);

	vec2 pos = vec2(
		in_pos.x * c - in_pos.y * s, 
		in_pos.x * s + in_pos.y * c);

	// Scale
	pos *= in_instance_scale;

	// Translate
	pos += in_instance_pos;

	// UVS: Transform from 0..1 mesh range to target sprite range
	vec2 sprite_uv = in_instance_sprite_uv_rect.xy + in_uv * in_instance_sprite_uv_rect.zw;

	gl_Position 			= to_screen_pos_2d(pos);
	frag_color 				= in_instance_color;
	frag_mesh_pos 			= in_pos;
	frag_light_texture_uv 	= sprite_uv;
	frag_depth 				= in_angle_and_depth.y;
	frag_shadow_map_uv 		= vec2(in_angle_and_depth.x, in_instance_shadow_map_v);
}
