/*
	vec2 step = vec2(step_x, step_y);
	pixel_uv_0 = in_uv;
	pixel_uv_1 = in_uv + step * 1.407333;
	pixel_uv_2 = in_uv - step * 1.407333;
	pixel_uv_3 = in_uv + step * 3.294215;
	pixel_uv_4 = in_uv - step * 3.294215;
}
*/

// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from engine (per vertex)
attribute highp vec2 in_pos;
attribute highp vec2 in_uv;
attribute lowp  vec4 in_color;

uniform mediump vec2 uni_fb_resolution;
uniform mediump vec2 uni_texture_resolution;

// Output to pixel shader
varying mediump vec2 pixel_uv_0;
varying mediump vec2 pixel_uv_1;
varying mediump vec2 pixel_uv_2;
varying mediump vec2 pixel_uv_3;
varying mediump vec2 pixel_uv_4;

vec2 uv_step(float x)
{
	return 1.0 / uni_texture_resolution * x;
}

void main(void)
{
	gl_Position = to_screen_pos_2d(in_pos);

	// Kludge: just something to keep the in_color bound here so I don't have to change the c++ vertex code
	float dummy = in_color.x * 0.00001;

	vec2 step = uv_step(1.0 + dummy);
//	vec2 step = uv_step(0.75);

	pixel_uv_0 = in_uv;
	pixel_uv_1 = in_uv + vec2(step.x, 0.0);
	pixel_uv_2 = in_uv - vec2(step.x, 0.0);
	pixel_uv_3 = in_uv + vec2(0.0, step.y);
	pixel_uv_4 = in_uv - vec2(0.0, step.y);
	
/*
	pixel_uv_1 = in_uv + vec2(step.x, step.y);
	pixel_uv_2 = in_uv + vec2(step.x, -step.y);
	pixel_uv_3 = in_uv + vec2(-step.x, step.y);
	pixel_uv_4 = in_uv + vec2(-step.x, -step.y);
*/	
}
