/*
void main(void) 
{
	lowp vec4 sum = vec4(0.0);

	sum += texture2D(texture, pixel_uv_0) * 0.204164;
	sum += texture2D(texture, pixel_uv_1) * 0.304005;
	sum += texture2D(texture, pixel_uv_2) * 0.304005;
	sum += texture2D(texture, pixel_uv_3) * 0.093913;
	sum += texture2D(texture, pixel_uv_4) * 0.093913;
	
	gl_FragColor = sum;
}
*/

// Copyright (C) Kimmo Lahtinen - All Rights Reserved

float gray(vec3 color)
{
//	return color.r * 0.2126 + color.g * 0.7152 + color.b * 0.0722;
	return (color.r + color.g + color.b) / 3.0;
}

// Input from vertex shader
varying mediump vec2 pixel_uv_0;
varying mediump vec2 pixel_uv_1;
varying mediump vec2 pixel_uv_2;
varying mediump vec2 pixel_uv_3;
varying mediump vec2 pixel_uv_4;

uniform sampler2D uni_texture_diffuse;

uniform vec4 	uni_colorize_color_and_brightness;
uniform float 	uni_effect_strength;

void main(void) 
{
	vec3 colorize = uni_colorize_color_and_brightness.rgb;
	float extra_brightness = uni_colorize_color_and_brightness.a;

	float vignette_center_size = 0.20;
	float vignette_pow = 3.0;

	float w_center = 0.30;
	float w_blur = 0.17;

//	uni_effect_strength *= 0.8;

//	w_blur *= step(0.2, abs(pixel_uv_0.x - 0.5));

	vec3 sum = vec3(0.0);
	vec3 actual = texture2D(uni_texture_diffuse, pixel_uv_0).rgb;
	sum += actual.rgb * w_center;
	sum += texture2D(uni_texture_diffuse, pixel_uv_1).rgb * w_blur;
	sum += texture2D(uni_texture_diffuse, pixel_uv_2).rgb * w_blur;
	sum += texture2D(uni_texture_diffuse, pixel_uv_3).rgb * w_blur;
	sum += texture2D(uni_texture_diffuse, pixel_uv_4).rgb * w_blur;
	
	float uv_dist_to_center = length(pixel_uv_0 - 0.5);
	float vignette_base = 1.0 - max(0.0, uv_dist_to_center - vignette_center_size);
	float vignette = pow(vignette_base, vignette_pow);

	float value = (gray(sum) + extra_brightness) * vignette;
	gl_FragColor = vec4(mix(actual, colorize * value, uni_effect_strength), 1.0);

//	gl_FragColor *= 0.0001;
//	gl_FragColor += sum;
}
