// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from vertex shader
varying lowp vec4 pixel_color;
varying mediump vec2 pixel_uv_fade;
varying mediump vec2 pixel_uv_animation;

uniform sampler2D uni_texture;

void main(void) 
{
	lowp vec4 tex_fade = texture2D(uni_texture, pixel_uv_fade);
	lowp vec4 tex_anim = texture2D(uni_texture, pixel_uv_animation);
	gl_FragColor = tex_fade * tex_anim * pixel_color;
}
