// Copyright (C) 2011 Kimmo Lahtinen - All Rights Reserved

// Uniform transforms
// ...

// Input from engine (per vertex)
attribute vec4 in_pos_and_is_culled;

// Output to pixel shader
varying highp vec2 pixel_uv_overlay;

void main(void)
{
	vec3 pos = in_pos_and_is_culled.xyz;

	// Throw the tiles that are completely below water away for culling, so we don't waste fill on shit 
	// devices... kludge, but easier to do it like this than to do it in CPU geometry generation
	// Note: leaves shore tiles as they are blended in
	pos.z += in_pos_and_is_culled.w * 1000.0;

	gl_Position 		= to_screen_pos_3d(pos);
	pixel_uv_overlay	= pos.xy / uni_map_size_max;

	// Kludge:
	// If the level is smaller than max size, then we have extra space in the lightmap that is black (at 
	// the positive end of the RT), so border vertices will sample that and produce an ugly black border.
	// So to counter that, we kludge adjust the UV a bit inwards in that case to avoid it

	if (pos.x > uni_map_size_current.x - 0.1) pixel_uv_overlay.x -= 0.0002;
	if (pos.y > uni_map_size_current.y - 0.1) pixel_uv_overlay.y -= 0.0002;
}
