// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from vertex shader
varying mediump vec3 frag_color;
varying mediump vec2 frag_diffuse_uv;
varying mediump vec2 frag_shadow_uv;

// Uniforms
uniform lowp sampler2D uni_texture_diffuse_rt;
uniform lowp sampler2D uni_texture_shadows;

uniform mediump float uni_shadow_mul;

void main(void) 
{
	vec3  texture_color_tile	= texture2D(uni_texture_diffuse_rt, frag_diffuse_uv).rgb;
	float shadow_strength		= 1.0 - (texture2D(uni_texture_shadows, frag_shadow_uv).r * uni_shadow_mul);

	vec3 color = texture_color_tile * frag_color;
	color *= (shadow_strength * LIGHTMAP_COLOR_WRITE_FACTOR);

	gl_FragColor.rgb = color;
	gl_FragColor.a = 1.0;
}
