// Copyright (C) Kimmo Lahtinen - All Rights Reserved

// Input from vertex shader
varying vec2 frag_uv_base;
varying vec2 frag_uv_grass;
varying vec2 frag_uv_roots;
varying vec2 frag_uv_lightmap;
varying float frag_overlay_alpha;
varying vec3 frag_light_color;

// Uniforms
uniform lowp sampler2D uni_texture_base;
uniform lowp sampler2D uni_texture_grass_overhang;
uniform lowp sampler2D uni_texture_roots_overhang;

void main(void) 
{
	// TODO: would be nicer with premultiplied alpha textures
	// -> need to do an easier and better asset pipeline for that to happen though

	vec4 base_color = texture2D(uni_texture_base, frag_uv_base);
	vec3 final_color = base_color.rgb;

	vec4 roots_color = texture2D(uni_texture_roots_overhang, frag_uv_roots);
	roots_color *= frag_overlay_alpha;

	final_color = roots_color.rgb * roots_color.a + final_color * (1.0 - roots_color.a);
	final_color *= frag_light_color;

	// TODO: premultiply this and one channel this -> much more nicer code here
	vec4 grass_color = texture2D(uni_texture_grass_overhang, frag_uv_grass);
	grass_color *= frag_overlay_alpha;

	vec3 lightmap_color = sample_level_lightmap(frag_uv_lightmap);
	grass_color.rgb *= lightmap_color;

	final_color = grass_color.rgb * grass_color.a + final_color * (1.0 - grass_color.a);

	gl_FragColor.rgb = final_color * base_color.a;
	gl_FragColor.a = base_color.a;

	// TODO: drop hanging vines... base_color.a
//	gl_FragColor.a = 1.0;
}
