
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_captain_melee
CPP_wm_skellington_mage
CPP_wm_spider
CPP_wm_bombshroom
CCP_wm_bulletorama
--]]

--set_global("g_debug_start_at_wave", 10) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spammer_free_in_time(8, 10.0, CPP_wm_spider),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.50), 
    waves_repeat(
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.5, 7), CPP_wm_skellington_melee),
    },
    3,
    3.0))
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(18.0, 0.60), 
    { 
      wave_spammer_free_in_time(5, 10.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(5, 10.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(8, 10.0, CPP_wm_bombshroom),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.50), 
    waves_repeat(
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.5, 7), CPP_wm_skellington_melee),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 0.5, 3), CPP_wm_skellington_archer),
    },
    4,
    3.0))
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(15.0, 0.60), 
    { 
      wave_spammer_free_in_time(10, 10.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(10, 10.0, CPP_wm_skellington_archer),
    })
end)

local function wave_line(y_coord, et)
	return wave_spawn(pos_single_line(vec(-6.5, y_coord), vec(6.5, y_coord), 8), et)
end

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(50.0, 0.60), 
    waves_repeat(
    { 
      wave_line(0.0, CPP_wm_skellington_archer),
      wave_timed_wait(6.0),
      wave_line(-6.5, CPP_wm_skellington_archer),
      wave_line( 6.5, CPP_wm_skellington_archer),
      wave_timed_wait(6.0),
      wave_line(-2.0, CPP_wm_skellington_melee),
      wave_line(2.0, CPP_wm_skellington_melee),
      wave_timed_wait(6.0),
    },
    1,
    0.0))
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(8.0, 0.30), 
    { 
      wave_line( 0.0, CPP_wm_skellington_captain_melee),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(13.0, 0.40), 
    { 
      wave_line(-3.5, CPP_wm_spider),
      wave_line( 3.5, CPP_wm_spider),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(60.0, 0.60), 
    { 
      wave_spammer_free_in_time(20, 30.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(25, 29.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(25, 28.0, CPP_wm_skellington_archer),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
