
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_knight
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_captain_bomber
CPP_wm_skellington_mage
CPP_wm_skellington_fire_bomber
CPP_wm_ninja
CPP_wm_spider
CPP_wm_spider_fire
CPP_wm_bombshroom
CCP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
CPP_wm_glowy
CPP_wm_robo_bomber
--]]

--set_global("g_debug_start_at_wave", 12) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.75), 
    { 
      wave_spammer_box_on_player(4.5, 12, 0.6, CPP_wm_skellington_melee), 
      wave_timed_wait(3.0),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_single_line(vec(-5.0, -6.5), vec(5.0, -6.5), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec(-5.0,  6.5), vec(5.0,  6.5), 6), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.70), 
    { 
      wave_spammer_free_in_time( 12, 10.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(  8, 10.0, CPP_wm_shockblob),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 6), CPP_wm_skellington_melee),
      wave_timed_wait(2.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_archer),
      wave_timed_wait(2.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 4.0, 12), CPP_wm_skellington_melee),
      wave_timed_wait(2.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_skellington_archer),
      wave_timed_wait(2.0),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.80), 
    { 
      wave_spammer_free_in_time( 12, 8.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(  8, 8.0, CPP_wm_shockblob),
      wave_spammer_box_on_player(3.5, 16, 0.5, CPP_wm_skellington_melee), 
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.4), 
    { 
      wave_spammer_free_in_time( 10, 5.0, CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(60.0, 0.80), 
    { 
      wave_spammer_box_on_player(2.5, 10, 1.0, CPP_wm_rollerball), 
      wave_spammer_free_in_time( 10, 8.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(  4, 8.0, CPP_wm_shockblob),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.6), 
    { 
      wave_spawn(pos_single_line(vec(-5.0, -6.5), vec(5.0, -6.5), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec(-5.0,  6.5), vec(5.0,  6.5), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec(-5.0, -3.5), vec(5.0, -3.5), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec(-5.0,  3.5), vec(5.0,  3.5), 6), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.4), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 6.0, 24), CPP_wm_skellington_melee),
      wave_timed_wait(5.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.6, 12), CPP_wm_robo_bomber),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.5), 
    { 
      wave_spammer_free_in_time( 10, 5.0, CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.80), 
    { 
      wave_spammer_free_in_time( 20, 14.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time( 20, 14.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 10, 14.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(  4, 14.0, CPP_wm_robo_bomber),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
