
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_mage
CPP_wm_skellington_fire_bomber
CPP_wm_spider
CPP_wm_bombshroom
CCP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
--]]

--set_global("g_debug_start_at_wave", 7) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- Slow start with basic enemies

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.60), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0, 0), 6.0, 10, 2.0, CPP_wm_skellington_melee), 
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.70), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(-10, 10), 2.0, 5, 4.5, CPP_wm_skellington_melee), 
      wave_spammer_box(vec( 10,-10), 2.0, 4, 3.0, CPP_wm_skellington_melee), 
      wave_spammer_box(vec( 10, 10), 2.0, 5, 3.5, CPP_wm_skellington_melee), 
      wave_spammer_box(vec(-10,-10), 2.0, 5, 4.0, CPP_wm_skellington_melee), 
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.65), 
    { 
      wave_spammer_free_in_time(4, 12.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(8, 12.0, CPP_wm_skellington_archer),
    })
end)

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(25.0, 0.70), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 18), CPP_wm_skellington_melee),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 6), CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.40), 
    { 
      wave_spammer_free_in_time(20, 15.0, CPP_wm_bulletorama),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.60), 
    { 
      wave_spawn(pos_single_line(vec(-2.5, -6.0), vec(2.5, -6.0), 4), CPP_wm_skellington_fire_bomber),
      wave_spawn(pos_single_line(vec(-2.5,  6.0), vec(2.5,  6.0), 4), CPP_wm_skellington_fire_bomber),
      wave_spammer_free_in_time(4, 10.0, CPP_wm_skellington_melee),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(15.0, 0.70), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 5), CPP_wm_shockblob),
    })
end)


add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.40), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0, 0), 8.0, 20, 0.7, CPP_wm_skellington_melee), 
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.75), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(-10, 10), 2.0, 2, 2.5, CPP_wm_shockblob), 
      wave_spammer_box(vec( 10,-10), 2.0, 3, 3.0, CPP_wm_shockblob), 
      wave_spammer_box(vec( 10, 10), 2.0, 2, 2.5, CPP_wm_shockblob), 
      wave_spammer_box(vec(-10,-10), 2.0, 3, 4.0, CPP_wm_shockblob), 
      wave_spammer_free_in_time(6, 15.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(10, 15.0, CPP_wm_skellington_melee),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(50.0, 0.75), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.5, 5), CPP_wm_skellington_captain_shooter),
      wave_timed_wait(2.0),
      wave_spawn(pos_single_line(vec(-6.0, -2.5), vec(-6.0, 2.5), 4), CPP_wm_skellington_fire_bomber),
      wave_spawn(pos_single_line(vec( 6.0, -2.5), vec( 6.0, 2.5), 4), CPP_wm_skellington_fire_bomber),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(24.0, 0.50), 
    { 
      wave_spammer_free_in_time(12, 12.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(6, 12.0, CPP_wm_skellington_fire_bomber),
      wave_spammer_free_in_time(3, 12.0, CPP_wm_shockblob),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
