
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_captain_melee
CPP_wm_skellington_mage
CPP_wm_spider
--]]

--set_global("g_debug_start_at_wave", 11) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
  	wait_time_or_dead(15, 0.50), 
  	waves_repeat(
	  {
	    wave_spawn(pos_single(vec(0.0,  0.0)), CPP_wm_skellington_melee),
	  },
	  4,
	  2.0))
end)

add_wave(function ()
	local dist = 1.0
	return waves_sequential(
		wait_time_or_dead(10.0, 0.50),
    { 
			wave_spawn(pos_single(vec(dist, 0.0)), CPP_wm_skellington_melee),
			wave_spawn(pos_single(vec(-dist, 0.0)), CPP_wm_skellington_melee),
			wave_spawn(pos_single(vec(0.0, dist)), CPP_wm_skellington_melee),
			wave_spawn(pos_single(vec(0.0, -dist)), CPP_wm_skellington_melee),
    })
end)

add_wave(function ()
	local dist = 5.0
	local wait = 1.5
	local enemy = CPP_wm_skellington_melee
  return waves_sequential(
    wait_time_or_dead(40.0, 0.5), 
    waves_repeat(
    { 
      wave_spawn(pos_single(vec(dist, 0.0)), enemy),
      wave_timed_wait(wait),
      wave_spawn(pos_single(vec(0.0, dist)), enemy),
      wave_timed_wait(wait),
      wave_spawn(pos_single(vec(-dist, 0.0)), enemy),
      wave_timed_wait(wait),
      wave_spawn(pos_single(vec(0.0, -dist)), enemy),
      wave_timed_wait(wait),
    },
    2,
    0.0))
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.65), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0,0), 3.0, 4, 2.5, CPP_wm_skellington_melee), 
      wave_spammer_box(vec(0,0), 3.0, 4, 2.0, CPP_wm_skellington_archer), 
      wave_spammer_free_in_time(4, 10.0, CPP_wm_spider),
    })
end)

-------------------------------------------------------------------------------
-- Mages

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 1), CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.65), 
    { 
      wave_spammer_free_in_time(8, 10.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(4, 10.0, CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 3), CPP_wm_skellington_mage),
    })
end)

-------------------------------------------------------------------------------
-- Some chase annoyance (grenade can't shoot close)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.75), 
    { 
      wave_chase(20, 1.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(6, 20.0, CPP_wm_spider),
    })
end)

-------------------------------------------------------------------------------
-- Finale

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(15.0, 0.6), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 4), CPP_wm_skellington_mage),
      wave_spammer_free_in_time(10, 20.0, CPP_wm_skellington_melee),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
