
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_knight
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_captain_bomber
CPP_wm_skellington_mage
CPP_wm_skellington_fire_bomber
CPP_wm_spider
CPP_wm_bombshroom
CCP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
--]]

--set_global("g_debug_start_at_wave", 6) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- Easy start

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(40.0, 0.60), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box(vec(0, 0), 5.0, 10, 2.0, CPP_wm_skellington_dog), 
    })
end)

-------------------------------------------------------------------------------
-- Archers at corners

local function wave_archer_bunch(pos, count)
	return wave_spammer_box(pos, 3.0, count, 1.0, CPP_wm_skellington_archer)
end

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.75), 
    { 
    	wave_archer_bunch(vec(-7, -7), 5), 
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.75), 
    { 
    	wave_archer_bunch(vec(7, 7), 5),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.75), 
    { 
    	wave_archer_bunch(vec(-7, 7), 5), 
    	wave_archer_bunch(vec(7, -7), 5), 
    })
end)

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(8.0, 0.75), 
    { 
	    wave_spawn(pos_single(vec(0.0,  0.0)), CPP_wm_skellington_captain_bomber),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.80), 
    { 
      wave_spammer_free_in_time(10, 5.0, CPP_wm_skellington_dog),
      wave_spammer_free_in_time(4,  5.0, CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.70), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_free_in_time(4, 20.0, CPP_wm_skellington_dog),
      wave_spammer_box(vec(0, 0), 6.0, 10, 2.0, CPP_wm_skellington_knight), 
    })
end)

-------------------------------------------------------------------------------
-- Bombers + finale

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 3), CPP_wm_skellington_captain_bomber),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(60.0, 0.70), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_free_in_time(8, 20.0, CPP_wm_skellington_knight),
      wave_spammer_free_in_time(5, 20.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(16, 20.0, CPP_wm_skellington_dog),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
