
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_knight
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_captain_bomber
CPP_wm_skellington_mage
CPP_wm_skellington_fire_bomber
CPP_wm_ninja
CPP_wm_spider
CPP_wm_spider_fire
CPP_wm_bombshroom
CCP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
--]]

--set_global("g_debug_start_at_wave", 6) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- ...

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.75), 
    { 
      -- pos, size, amount, interval, et
      wave_spammer_box_on_player(4.5, 8, 1.0, CPP_wm_skellington_melee), 
      wave_timed_wait(3.0),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.5, 3), CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.80), 
    { 
      wave_spammer_box_on_player(4.5, 6, 1.0, CPP_wm_skellington_melee), 
      wave_spammer_free_in_time( 4, 5.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 8, 5.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time( 1, 5.0, CPP_wm_shockblob),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(40.0, 0.6), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.5, 5), CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(40.0, 0.80), 
    waves_repeat(
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.5, 7), CPP_wm_spider_fire),
    },
    3,
    4.0))
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(6.0, 0.50), 
    { 
	    wave_spawn(pos_single(vec(0.0, 0.0)), CPP_wm_ninja),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.60), 
    { 
      wave_spammer_box_on_player(3.5, 8, 1.5, CPP_wm_skellington_melee), 
      wave_spammer_free_in_time( 8, 20.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 8, 20.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time( 1, 20.0, CPP_wm_shockblob),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(10.0, 0.4), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 7), CPP_wm_skellington_mage),
    })
end)


add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(25.0, 0.70), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.5, 5), CPP_wm_spider_fire),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.50), 
    { 
      wave_spammer_box_on_player(3.5, 10, 2.0, CPP_wm_skellington_melee), 
      wave_spammer_free_in_time(12, 20.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(10, 20.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time( 2, 20.0, CPP_wm_shockblob),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
