
--[[
CPP_wm_skellington_melee
CPP_wm_skellington_archer
CPP_wm_skellington_dog
CPP_wm_skellington_knight
CPP_wm_skellington_captain_melee
CPP_wm_skellington_captain_shooter
CPP_wm_skellington_captain_bomber
CPP_wm_skellington_emperor
CPP_wm_skellington_mage
CPP_wm_skellington_fire_bomber
CPP_wm_ninja
CPP_wm_spider
CPP_wm_spider_fire
CPP_wm_bombshroom
CPP_wm_bulletorama
CPP_wm_rollerball
CPP_wm_shockblob
CPP_wm_glowy
CPP_wm_robo_bomber
--]]

--set_global("g_debug_start_at_wave", 35) -- Note: indices start at 1
--set_global("g_debug_never_end", true)

-------------------------------------------------------------------------------
-- Helpers

-- Basic captain drops now and then to provide the player with some secondary weapons
local function do_captain_drop_wave(radius, amount)
  add_wave(function ()
    return waves_sequential(
      wait_time_or_dead(5.0, 0.25), 
      { 
        wave_spawn(pos_gen_circle(vec(0.0, 0.0), radius, amount), CPP_wm_skellington_captain_melee),
      })
  end)
end

-------------------------------------------------------------------------------
-- Wait a bit for player to land

add_wave_initial_wait()

-------------------------------------------------------------------------------
-- Begin with some massive basic skellington waves

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(15.0, 0.75), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_melee),
      wave_timed_wait(2.5),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 4.0, 12), CPP_wm_skellington_melee),
      wave_timed_wait(2.5),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_skellington_melee),
      wave_timed_wait(2.5),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 6.0, 20), CPP_wm_skellington_melee),
      wave_timed_wait(2.5),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(15.0, 0.65), 
    { 
      wave_spammer_box_on_player(6.0, 14, 0.6, CPP_wm_skellington_melee), 
      wave_spammer_box_on_player(6.0, 14, 0.6, CPP_wm_skellington_archer), 
    })
end)

do_captain_drop_wave(0.0, 1)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_single_line(vec(-4.5, -4.0), vec(-4.5,  4.0), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec( 4.5, -4.0), vec( 4.5,  4.0), 6), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_single_line(vec(-4.0, -4.5), vec(4.0, -4.5), 6), CPP_wm_skellington_archer),
      wave_spawn(pos_single_line(vec(-4.0,  4.5), vec(4.0,  4.5), 6), CPP_wm_skellington_archer),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.75), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 3), CPP_wm_skellington_dog),
      wave_timed_wait(1.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 6), CPP_wm_skellington_dog),
      wave_timed_wait(1.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_dog),
      wave_timed_wait(1.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 4.0, 12), CPP_wm_skellington_dog),
      wave_timed_wait(1.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_skellington_dog),
      wave_timed_wait(1.0),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.65), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_skellington_archer),
    })
end)

do_captain_drop_wave(2.0, 3)

-------------------------------------------------------------------------------
-- Time for monster waves


add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.80), 
    { 
      wave_spammer_free_in_time( 40, 15.0, CPP_wm_bombshroom),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 6, 15.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time( 14, 15.0, CPP_wm_bulletorama),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.20), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.5, 6), CPP_wm_shockblob),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_skellington_archer),
    })
end)

do_captain_drop_wave(2.0, 3)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.75), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_archer),
      wave_spammer_box_on_player(2.5, 10, 1.0, CPP_wm_rollerball), 
    })
end)

-- Spam a bit of everything so far

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spammer_free_in_time( 5, 15.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 3, 15.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(10, 15.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time( 7, 15.0, CPP_wm_bulletorama),
      wave_spammer_free_in_time( 4, 15.0, CPP_wm_shockblob),
    })
end)

do_captain_drop_wave(12.0, 5)

-------------------------------------------------------------------------------
-- Bring the fire + tougher skellies

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_melee),
      wave_spawn(pos_single_line(vec(-4.5, -4.0), vec(-4.5,  4.0), 6), CPP_wm_skellington_fire_bomber),
      wave_spawn(pos_single_line(vec( 4.5, -4.0), vec( 4.5,  4.0), 6), CPP_wm_skellington_fire_bomber),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.5), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_melee),
      wave_spawn(pos_single_line(vec(-4.0, -4.5), vec(4.0, -4.5), 6), CPP_wm_skellington_fire_bomber),
      wave_spawn(pos_single_line(vec(-4.0,  4.5), vec(4.0,  4.5), 6), CPP_wm_skellington_fire_bomber),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.80), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 16), CPP_wm_spider),
      wave_timed_wait(5.0),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 10), CPP_wm_spider_fire),
    })
end)

do_captain_drop_wave(2.5, 5)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.50), 
    { 
      wave_spammer_box_on_player(4.5, 16, 0.6, CPP_wm_skellington_knight), 
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(30.0, 0.33), 
    { 
      wave_spammer_free_in_time(3, 10.0, CPP_wm_skellington_captain_bomber),
      wave_spammer_free_in_time(6, 10.0, CPP_wm_skellington_captain_shooter),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_dog),
      wave_spawn(pos_gen_circle(vec(7.0, 7.0), 1.0, 3), CPP_wm_skellington_mage),
      wave_spawn(pos_gen_circle(vec(-7.0, 7.0), 1.0, 3), CPP_wm_skellington_mage),
      wave_spawn(pos_gen_circle(vec(7.0, -7.0), 1.0, 3), CPP_wm_skellington_mage),
      wave_spawn(pos_gen_circle(vec(-7.0, -7.0), 1.0, 3), CPP_wm_skellington_mage),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 16), CPP_wm_spider),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 26), CPP_wm_spider_fire),
    })
end)

do_captain_drop_wave(2.5, 5)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.30), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_fire_bomber),
      wave_spammer_free_in_time( 8, 20.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time( 8, 20.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time(10, 20.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time( 4, 20.0, CPP_wm_shockblob),
    })
end)

do_captain_drop_wave(2.5, 5)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(40.0, 0.76), 
    { 
      wave_spawn(pos_gen_circle(vec(12.0, 12.0), 1.7, 7), CPP_wm_skellington_dog),
      wave_spawn(pos_gen_circle(vec(-12.0, 12.0), 1.7, 7), CPP_wm_skellington_dog),
      wave_spawn(pos_gen_circle(vec(12.0, -12.0), 1.7, 7), CPP_wm_skellington_dog),
      wave_spawn(pos_gen_circle(vec(-12.0, -12.0), 1.7, 7), CPP_wm_skellington_dog),
    })
end)

-------------------------------------------------------------------------------
-- Finally robot stuff + everything else missing

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(60.0, 0.75), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 2.0, 8), CPP_wm_robo_bomber),
    })
end)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(14.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 5), CPP_wm_ninja),
    })
end)

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(20.0, 0.50), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 8), CPP_wm_skellington_melee),
      wave_spammer_free_in_time(14, 5.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time(6, 5.0, CPP_wm_shockblob),
    })
end)

do_captain_drop_wave(2.5, 5)

add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(30.0, 0.80), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 3), CPP_wm_skellington_emperor),
    })
end)

--[[
add_wave(function ()
  return waves_sequential(
    wait_time_or_dead(20.0, 0.70), 
    { 
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 1.0, 5), CPP_wm_skellington_mage),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 3.0, 12), CPP_wm_skellington_archer),
      wave_spawn(pos_gen_circle(vec(0.0, 0.0), 5.0, 20), CPP_wm_skellington_melee),
    })
end)
--]]

-------------------------------------------------------------------------------
-- Finish it of with megaspam

add_wave(function ()
  return waves_parallel(
    wait_time_or_dead(120.0, 0.90), 
    { 
      wave_spammer_free_in_time(26, 70.0, CPP_wm_skellington_melee),
      wave_spammer_free_in_time(10, 50.0, CPP_wm_skellington_archer),
      wave_spammer_free_in_time( 5, 37.0, CPP_wm_skellington_dog),
      wave_spammer_free_in_time( 6, 60.0, CPP_wm_skellington_knight),
      wave_spammer_free_in_time( 4, 61.0, CPP_wm_skellington_captain_melee),
      wave_spammer_free_in_time( 2, 55.0, CPP_wm_skellington_captain_shooter),
--      wave_spammer_free_in_time( 2, 40.0, CPP_wm_skellington_captain_bomber),
      wave_spammer_free_in_time( 2, 58.0, CPP_wm_skellington_emperor),
--      wave_spammer_free_in_time( 8, 54.0, CPP_wm_skellington_fire_bomber),
--      wave_spammer_free_in_time( 2, 63.0, CPP_wm_ninja),
      wave_spammer_free_in_time( 5, 35.0, CPP_wm_spider),
--      wave_spammer_free_in_time( 6, 59.0, CPP_wm_spider_fire),
      wave_spammer_free_in_time(14, 56.0, CPP_wm_bombshroom),
      wave_spammer_free_in_time( 8, 63.0, CPP_wm_bulletorama),
      wave_spammer_free_in_time( 4, 42.0, CPP_wm_rollerball),
      wave_spammer_free_in_time( 4, 57.0, CPP_wm_shockblob),
--      wave_spammer_free_in_time( 3, 49.0, CPP_wm_robo_bomber),
    })
end)

-------------------------------------------------------------------------------
-- Final wait (all dead)

add_wave_final_wait()
